    #include<iostream>
    #include<algorithm>

    using namespace std;

    const int MAXN = 1000*1000 + 5;

    struct win_array{
        int n;
        int pref[MAXN];
        int sorted[MAXN];
        int fenwick[MAXN];

        win_array(){}
        void assign(const string & s, int p) {
            n = s.size();
            pref[0] = 0;
            fenwick[0] = 0;
            sorted[0] = 0;
            for(int i = 0; i < n; i++){
                pref[i + 1] = (s[i] == '0' ? -p : 100 - p) + pref[i];
                fenwick[i + 1] = 0;
                sorted[i + 1] = pref[i + 1];
            }
            sort(sorted, sorted + n + 1);
        }

        int sum (int r){
            int result = 0;
            for (; r >= 0; r = (r & (r+1)) - 1)
                result += fenwick[r];
            return result;
        }
        
        void inc (int i){
            for (; i <= n; i = (i | (i+1)))
                ++fenwick[i];
        }
        int sum (int l, int r){
            return sum (r) - sum (l-1);
        }

        long long get_cnt(){
            long long res = 0;
            int index = lower_bound(sorted, sorted + n + 1, 0) - sorted;
            inc(index);
                
            for(int i = 1; i <= n; i++){
                int index = lower_bound(sorted, sorted + n + 1, pref[i]) - sorted;
                
                res += sum(0, index); // change on index - 1 if sign is >, not >=
                inc(index);
            }
            return res;
        }
    } win;

    int main(){
        ios::sync_with_stdio(false);
        cin.tie(0);

        int Q;
        cin >> Q;
        while(Q--){
            int n, p;  
            cin >> n >> p;
            //string s;
            string s(n, '0');
            //cin >> s;
            for(int i = 0; i < n; i++)
                cin >> s[i];
            
            win.assign(s, p);
            cout << win.get_cnt() << ' ';
        }
        cout << '\n';

        


        return 0;
    }
